<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Session;

class SetLocale
{
    public function handle($request, Closure $next)
    {
        if (session()->has('locale')) {
            $locale = session('locale');
        } 
        // 2. Si no hay en sesión, intentar obtener el idioma del navegador
        elseif ($request->getPreferredLanguage(config('app.supported_locales'))) {
            $locale = $request->getPreferredLanguage(config('app.supported_locales'));
        } 
        else {
            // 3. Usar el idioma por defecto de la app
            $locale = config('app.locale');
        }

        // Establece el idioma para la aplicación
        App::setLocale($locale);

        // Continuar con la petición
        return $next($request);
    }
}
