<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('permissions', function (Blueprint $table) {
            $table->boolean('is_parent')->default(false)->after('guard_name');
            $table->unsignedBigInteger('parent')->nullable()->after('is_parent');
            
            // (Opcional) Foreign key para parent si querés integridad referencial
            $table->foreign('parent')->references('id')->on('permissions')->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::table('permissions', function (Blueprint $table) {
            $table->dropForeign(['parent']);
            $table->dropColumn(['is_parent', 'parent']);
        });
    }

};
