let reseteaForms = function (){
    $('#form-empresa')[0].reset();
    $('#form-contacto')[0].reset();
}

let habilitaSolapas = function (){
    $('.nav-tabs a[href="#empresa"]').attr('data-toggle', 'tab');
    $('.nav-tabs a[href="#contacto"]').attr('data-toggle', 'tab');
    $('.nav-tabs a[href="#pagina"]').attr('data-toggle', 'tab');
}

let reseteaSolapas = function (){
    $('.nav-tabs a[href="#empresa"]').removeAttr('data-toggle');
    $('.nav-tabs a[href="#contacto"]').removeAttr('data-toggle');
    $('.nav-tabs a[href="#pagina"]').removeAttr('data-toggle');
}

let removerLogo = function(event, element){
    let image = element.settings.defaultFile.split("/");
    let idEmpresa = $("#idEmpresa").val();
    if(idEmpresa!=0){
        $.ajax({
            method: 'GET',
            url: $urlBase + '/administracion/empresa/eliminarlogo',
            data: {
                idEmpresa: idEmpresa,
                filename: image[image.length - 1]
            },
            dataType: 'JSON',
            success: function (response){ }
        });
    }
}

let removerFavicon = function(event, element){
    let image = element.settings.defaultFile.split("/");
    let idEmpresa = $("#idEmpresa").val();
    if(idEmpresa!=0){
        $.ajax({
            method: 'GET',
            url: $urlBase + '/administracion/empresa/eliminarfavicon',
            data: {
                idEmpresa: idEmpresa,
                filename: image[image.length - 1]
            },
            dataType: 'JSON',
            success: function (response){ }
        });
    }
}

let removerPagina = function (idPagina){
    Swal.fire({
        title: "Confirmacion",
        text: "Seguro que desea eliminar esta pagina?",
        type: "warning",
        showCancelButton: true,
        confirmButtonColor: "#3085d6",
        cancelButtonColor: "#d33",
        confirmButtonText: "SI",
        cancelButtonText: "NO"
      }).then(function (result) {
        if(result.value) {
            let url = $urlBase + '/administracion/empresa/pagina/delete/' + idPagina;
            $.ajax({
                method: 'GET',
                url: url,
                dataType: 'JSON',
                success: function (response){ 
                    Swal.fire({
                        title: '',
                        text: response.message,
                        type: 'success',
                        confirmButtonClass: 'btn btn-confirm mt-2'
                    }).then(function (){
                        getPaginas($("#idEmpresa").val());         
                    });
                }
            });
        }
    });
}

let getPaginas = function (idEmpresa){
    let url = $urlBase + "/administracion/empresa/paginas/" + idEmpresa;
    $.ajax({
        url: url,
        method: "GET",
        success: function (response){
            let tblPaginas = $("#tbl-paginas tbody");
            tblPaginas.html("");
            if(response.success){
                $.each(response.data, function (i, e){
                    tblPaginas.append(`<tr>
                        <td class="text-left">${e.Titulo}</td>
                        <td class="text-center">${e.FecUltActualizacion}</td>
                        <td class="text-center">${e.Publicada}</td>
                        <td class="text-center">
                            <div>
                                <a href="javascript:void(0);" class="action-icon" onclick="editarPagina(${e.id});">
                                    <i class="mdi mdi-square-edit-outline"></i>
                                </a>
                                <a href="javascript:void(0);" class="action-icon" onclick="removerPagina(${e.id});">
                                    <i class="mdi mdi-delete"></i>
                                </a>
                            </div>
                        </td>
                    </tr>`);
                });
            }else{
                tblPaginas.append(`<tr>
                    <td class="text-center" colspan="4">${response.message}</td>
                </tr>`);
            }
        }
    });
}

let editarEmpresa = function (idEmpresa){
    let url = $urlBase + "/administracion/empresa/editar/" + idEmpresa;
    $.ajax({
        url: url,
        method: 'GET',
        success: function (response){
            if(response.success){
                let empresa = response.data.empresa;
                let parametros = response.data.parametros;
                
                $("#idEmpresa").val(empresa.idEmpresa);
                $("#RazonSocial").val(empresa.RazonSocial);
                $("#CUIT").val(empresa.CUIT);
                $("#idCatFiscal").val(empresa.idTipoEmpresa);
                $("#Descrip").val(empresa.Descrip);
                $("#Domicilio").val(empresa.Domicilio);
                $("#CodigoPostal").val(empresa.CodigoPostal);
                $("#ClaveWS").val(empresa.ClaveWS);
                $("#FechaVigenciaTope").val(empresa.FechaVigenciaTope);
                $("#Hab").val(empresa.Hab);           
                $("#DataFiscal").val(parametros.Red_DataFiscal);
                $("#Email").val(empresa.Email);
                $("#WhatsApp").val(empresa.WhatsApp);
                $("#Telefonos").val(empresa.Telefonos);
                $("#Red_Facebook").val(parametros.Red_Facebook);
                $("#Red_Twitter").val(parametros.Red_Twitter);
                $("#Red_Instagram").val(parametros.Red_Instagram);
                $("#idPais").val(empresa.idPais);
                $("#idPais").trigger("change");
                setTimeout(function (){
                    $("#idProvincia").val(empresa.IdProvincia);
                    $("#idProvincia").trigger("change");
                    setTimeout(function (){
                        $("#idPartido").val(empresa.IdPartido);
                        $("#idPartido").trigger("change");
                        setTimeout(function (){
                            $("#idLocalidad").val(empresa.IdLocalidad);
                            $("#idLocalidad").trigger("change");
                        }, 800);
                    }, 800);
                }, 800);

                let filenameLogo = (empresa.Logo)?$urlBase + "/public/logos/" + empresa.Logo:"";
                let filenameFavicon = (empresa.Favicon)?$urlBase + "/public/favicon/" + empresa.Favicon:"";
                
                $("#contenido-logo").html(`<input type="file" name="Logo" id="Logo" class="dropify-logo" data-default-file="${filenameLogo}" />`);
                let drEventLogo = $('#Logo').dropify({
                    messages: {
                        'default': 'Logo',
                        'replace': 'Logo',
                        'remove':  'Quitar',
                        'error':   'Fallo'
                    }
                });

                drEventLogo.on('dropify.afterClear', removerLogo);

                $("#contenido-favicon").html(`<input type="file" name="Favicon" id="Favicon" class="dropify-favicon" data-default-file="${filenameFavicon}" />`);
                let drEventFavicon = $('#Favicon').dropify({
                    messages: {
                        'default': 'Favicon',
                        'replace': 'Favicon',
                        'remove':  'Quitar',
                        'error':   'Fallo'
                    }
                });

                drEventFavicon.on('dropify.afterClear', removerFavicon);

                habilitaSolapas();
                $('.nav-tabs a[href="#empresa"]').tab('show');

                getPaginas(idEmpresa);
            }
        }
    });
}

let editarPagina = function (idPagina){
    let url = $urlBase + "/administracion/empresa/pagina/editar/" + idPagina;
    $.ajax({
        url: url,
        method: 'GET',
        success: function (response){
            let pagina = response.data;
            if(response.success){
                $("#modalPagina").modal("show");
                $("#idPagina").val(pagina.id);
                $("#Titulo").val(pagina.Titulo);
                $("#Publicada").val(pagina.Hab);
                quill.root.innerHTML = pagina.Contenido;
            }
        }
    });
}
  
let llenaComboBox = function (route, el){
    el.empty();
    el.append("<option></option>");
    $.ajax({
        url: route,
        method: 'GET',
        success: function (response){
            if(response.success){
                $.each(response.data, function (i, e){
                    el.append(`<option value="${e.id}">${e.text}</option>`);
                });
            } 
        }
    });
}

let empresa = function (){
    let initDataTable = function () {
        let languageJSON = {};
        let languageUrl = $urlBase + "/language/datatable";
        $.getJSON(languageUrl, function (remoteLanguage){
            languageJSON = {
                emptyTable: remoteLanguage.sEmptyTable,
                info: remoteLanguage.sInfo,
                infoEmpty: remoteLanguage.sInfoEmpty,
                infoFiltered: remoteLanguage.sInfoFiltered,
                infoPostFix: remoteLanguage.sInfoPostFix,
                infoThousands: remoteLanguage.sInfoThousands,
                lengthMenu: "",
                loadingRecords: remoteLanguage.sLoadingRecords,
                processing: remoteLanguage.processing,
                search: remoteLanguage.sSearch,
                zeroRecords: remoteLanguage.sZeroRecords,
                paginate: {
                    first: remoteLanguage.sFirst,
                    last: remoteLanguage.sLast,
                    previous: "<i class='mdi mdi-chevron-left'>",
                    next: "<i class='mdi mdi-chevron-right'>"
                },
                aria: {
                    sortAscending: remoteLanguage.sSortAscending,
                    sortDescending: remoteLanguage.sSortDescending,
                },
            };  

            let oTable = $("#empresa-datatable").DataTable({
                dom: `
                    <'row'<'col-sm-4 text-left'f><'col-sm-8'p>>
                    <'row'<'col-sm-12't>>
                    <'row'<'col-sm-4'i><'col-sm-8'p>>
                `,
                language: languageJSON,
                serverSide: true,
                ajax: {
                    url: $urlBase + "/administracion/empresa/get",
                    dataType: "json"
                },
                pageLength: 50,
                columns: [{
                    data: "idEmpresa",
                    orderable: false,
                        render: function(data, type, row, meta) {
                            if (type === "display") {
                                data = `<div class="custom-control custom-checkbox">
                                    <input type="checkbox" class="custom-control-input dt-checkboxes">
                                        <label class="custom-control-label">&nbsp;</label>
                                    </div>`;
                            }
                            return data;
                        },
                        checkboxes: {
                            selectRow: true,
                            selectAllRender: `<div class="custom-control custom-checkbox">
                                <input type="checkbox" class="custom-control-input dt-checkboxes">
                                    <label class="custom-control-label">&nbsp;</label>
                            </div>`
                        }
                    },
                    { data: "idEmpresa", orderable: true, className: "text-center" },
                    { data: "RazonSocial", orderable: true, className: "text-left" },
                    { data: "Email", orderable: true, className: "text-center" },
                    { data: "Telefonos", orderable: true, className: "text-center" },
                    { data: "WhatsApp", orderable: true, className: "text-center" },
                    { data: "FechaVigenciaTope", orderable: true, className: "text-center" },
                    { data: "Hab", orderable: true, className: "text-center", 
                        render: function (data, type, row){
                            if(data == 1){
                                return `<span class="badge badge-soft-success">SI</span>`;
                            }else{
                                return `<span class="badge badge-soft-danger">NO</span>`;
                            }
                        }
                    }
                ],
                columnDefs: [{
                    title: "Accion",
                    targets: 8,
                    data: null,
                    className: "text-center",
                    defaultContent: `<div>
                        <a href="javascript:void(0);" class="action-icon" id="btnEditar">
                            <i class="mdi mdi-square-edit-outline"></i>
                        </a>
                        <a href="javascript:void(0);" class="action-icon" id="btnEliminar">
                            <i class="mdi mdi-delete"></i>
                        </a>
                    </div>`
                }],
                select: {
                    style: 'single'
                },
                order: [[1, "asc"]],
                drawCallback: function() {
                    $(".dataTables_paginate > .pagination").addClass("pagination-rounded");
                },
                info: true,
                initComplete: function (settings, json){
                    // After of Load DataTable    
                }
            });

            $("#empresa-datatable").on('change', 'input', function (e) {
                /*let oTable = $('#empresa-datatable').DataTable();
                oTable.$("input[type=checkbox]").prop("checked", false);
                $(this).prop("checked", true);
                let data = oTable.row($(this).parents('tr')).data();
                editarEmpresa(data.idEmpresa);*/
            });

            $("#empresa-datatable").on("click", "td:not(:has(div,input,a,button))", function (e){
                let oTable = $("#empresa-datatable").DataTable();
                var data = oTable.row($(this).parents('tr')).data();
                editarEmpresa(data.idEmpresa);
            });

            $("#empresa-datatable tbody").on("click", "#btnEditar, #btnEliminar, #btnVer", function (){
                let oTable = $("#empresa-datatable").DataTable();
                var data = oTable.row($(this).parents('tr')).data();
                if(this.id == "btnEditar"){
                    editarEmpresa(data.idEmpresa);
                }

                if(this.id == "btnEliminar"){
                    Swal.fire({
                        title: "Confirmacion",
                        text: "Seguro que desea eliminar la empresa " + data.idEmpresa,
                        type: "warning",
                        showCancelButton: true,
                        confirmButtonColor: "#3085d6",
                        cancelButtonColor: "#d33",
                        confirmButtonText: "SI",
                        cancelButtonText: "NO"
                      }).then(function (result) {
                        if (result.value) {
                            $.ajax({
                                method: 'GET',
                                url: $urlBase + "/administracion/empresa/delete/" + data.idEmpresa,
                                success: function (response){
                                    if(response.success){
                                        Swal.fire({
                                            title: '',
                                            text: response.message,
                                            type: 'success',
                                            confirmButtonClass: 'btn btn-confirm mt-2'
                                        });
                                        $("#empresa-datatable").DataTable().draw();                    
                                    }
                                }
                            });
                        }
                    });
                }
            });
        });    

        $("#btnTabGrilla").on("click", function (e){
            reseteaSolapas();
            reseteaForms();
        });

        $("#btnCancelarGoogle").on("click", function (e){
            $("#form-google")[0].reset();
            $("#modalGoogle").modal("hide");
        });

        $("#btnGoogleAnalytics").on("click", function (e){
            $("#modalGoogle").modal("show");
        });

        $("#btnNuevo").on("click", function (e){
            reseteaSolapas();
            reseteaForms();
            $('.nav-tabs a[href="#empresa"]').attr('data-toggle', 'tab');
            $('.nav-tabs a[href="#empresa"]').tab('show');
            $('#idEmpresa').val(0);

            $("#contenido-logo").html(`<input type="file" name="Logo" id="Logo" class="dropify-logo" />`);
            $("#contenido-favicon").html(`<input type="file" name="Favicon" id="Favicon" class="dropify-favicon" />`);
            
            $('#Logo').dropify({
                messages: {
                    'default': 'Logo',
                    'replace': 'Logo',
                    'remove':  'Quitar',
                    'error':   'Fallo'
                }
            });

            $('#Favicon').dropify({
                messages: {
                    'default': 'Favicon',
                    'replace': 'Favicon',
                    'remove':  'Quitar',
                    'error':   'Fallo'
                }
            });
        });

        $("#form-google").on("submit", function (e){
            e.preventDefault();
            let form = document.getElementById("form-google");
            let formData = new FormData(form);
            formData.append("idEmpresa", $("#idEmpresa").val());
            $.ajax({
                method: 'POST',
                url: $urlBase + '/administracion/empresa/google',
                data: formData,
                dataType: 'JSON',
                contentType: false,
                processData: false,
                beforeSend: function (){
                    $('.has-error .help-block').remove();                
                    $('.form-group').removeClass('has-error');
                },
                success: function (response){
                    if(response.success){
                        Swal.fire({
                            title: '',
                            text: response.message,
                            type: 'success',
                            confirmButtonClass: 'btn btn-confirm mt-2'
                        });
                        $("#modalGoogle").modal("hide");
                        $("#form-google")[0].reset();
                        getPaginas($("#idEmpresa").val());
                    }
                },
                error: function (error){
                    var res = error.responseJSON;
                    if ($.isEmptyObject(res) == false) {
                        $.each(res.errors, function (key, value) {
                            $('#' + key)
                                .closest('.form-group')
                                .addClass('has-error')
                                .append('<span class="help-block"><strong>' + value + '</strong></span>');
                        });
                    }
                }
            });

        });

        $("#form-empresa").on("submit", function (e){
            e.preventDefault();
            let form = document.getElementById("form-empresa");
            let formData = new FormData(form);
            $.ajax({
                method: 'POST',
                url: $urlBase + '/administracion/empresa/guardar',
                data: formData,
                dataType: 'JSON',
                contentType: false,
                processData: false,
                beforeSend: function (){
                    $('.has-error .help-block').remove();                
                    $('.form-group').removeClass('has-error');
                },
                success: function (response){
                    if(response.success){
                        $("#idEmpresa").val(response.idEmpresa);
                        Swal.fire({
                            title: '',
                            text: response.message,
                            type: 'success',
                            confirmButtonClass: 'btn btn-confirm mt-2'
                        }).then(function (){
                            habilitaSolapas();    
                            $("#empresa-datatable").DataTable().draw();                    
                        });
                    }
                },
                error: function (error){
                    var res = error.responseJSON;
                    if ($.isEmptyObject(res) == false) {
                        $.each(res.errors, function (key, value) {
                            $('#' + key)
                                .closest('.form-group')
                                .addClass('has-error')
                                .append('<span class="help-block"><strong>' + value + '</strong></span>');
                        });
                    }
                }
            });

        });

        $("#form-contacto").on("submit", function (e){
            e.preventDefault();
            let form = document.getElementById("form-contacto");
            let formData = new FormData(form);
            formData.append("idEmpresa", $("#idEmpresa").val());
            $.ajax({
                method: 'POST',
                url: $urlBase + '/administracion/empresa/contacto',
                data: formData,
                dataType: 'JSON',
                contentType: false,
                processData: false,
                beforeSend: function (){
                    $('.has-error .help-block').remove();                
                    $('.form-group').removeClass('has-error');
                },
                success: function (response){
                    if(response.success){
                        Swal.fire({
                            title: '',
                            text: response.message,
                            type: 'success',
                            confirmButtonClass: 'btn btn-confirm mt-2'
                        }).then(function (){
                            $("#empresa-datatable").DataTable().draw();                    
                        });
                    }
                },
                error: function (error){
                    var res = error.responseJSON;
                    if ($.isEmptyObject(res) == false) {
                        $.each(res.errors, function (key, value) {
                            $('#' + key)
                                .closest('.form-group')
                                .addClass('has-error')
                                .append('<span class="help-block"><strong>' + value + '</strong></span>');
                        });
                    }
                }
            });
        });

        $("#form-pagina").on("submit", function (e){
            e.preventDefault();
            let form = document.getElementById("form-pagina");
            let formData = new FormData(form);
            let Contenido = quill.root.innerHTML;
            formData.append("idioma", $("#Idi_idiomaPpal").val());
            formData.append("idEmpresa", $("#idEmpresa").val());
            formData.append("Contenido", Contenido);
            $.ajax({
                method: 'POST',
                url: $urlBase + '/administracion/empresa/pagina',
                data: formData,
                dataType: 'JSON',
                contentType: false,
                processData: false,
                beforeSend: function (){
                    $('.has-error .help-block').remove();                
                    $('.form-group').removeClass('has-error');
                },
                success: function (response){
                    if(response.success){
                        Swal.fire({
                            title: '',
                            text: response.message,
                            type: 'success',
                            confirmButtonClass: 'btn btn-confirm mt-2'
                        }).then(function (){
                            $("#modalPagina").modal("hide");
                            $("#form-pagina")[0].reset();
                            quill.root.innerHTML = "";
                            getPaginas($("#idEmpresa").val());         
                        });
                    }
                },
                error: function (error){
                    var res = error.responseJSON;
                    if ($.isEmptyObject(res) == false) {
                        $.each(res.errors, function (key, value) {
                            $('#' + key)
                                .closest('.form-group')
                                .addClass('has-error')
                                .append('<span class="help-block"><strong>' + value + '</strong></span>');
                        });
                    }
                }
            });
        });

        $("#btnGenerarClaveWS").on("click", function (e){
            let url = $urlBase + "/administracion/empresa/generar";
            $.ajax({
                url: url,
                method: 'GET',
                success: function (response){
                    $("#ClaveWS").val(response.code);
                }
            });
        });

        $("#btnCancelarEmpresa, #btnCancelarContacto, #btnCancelarPaginas").on("click", function (e){
            reseteaSolapas();
            reseteaForms();
            $('.nav-tabs a[href="#grilla"]').tab('show');
        });

        $("#btnCancelarModalPagina").on("click", function (e){
            $("#modalPagina").modal("hide");
            $("#form-pagina")[0].reset();
            quill.root.innerHTML = "";
        });

        $("#btnNuevaPagina, #btnNuevaPagina2").on("click", function (e){
            $("#modalPagina").modal("show");
            quill.root.innerHTML = "";
        });

        $("#cboTipoPagina").on("change", function (e){
            let id = $(this).val();
            if(id){
                let idioma = $("#Idi_idiomaPpal").val();
                let url = $urlBase + "/administracion/empresa/tipopagina/" + idioma + "/" + id;
                $.ajax({
                    url: url,
                    method: 'GET',
                    success: function (response){
                        if(response.success){
                            $("#Titulo").val(response.data.Descrip);
                            quill.root.innerHTML = response.data.TexSugerido;
                        }
                    }
                });
            }else{
                $("#Titulo").val("");
                quill.root.innerHTML = "";
            }
        });

        $("#idPais").on("change", function (e){
            let idPais = $(this).val();
            let el = $("#idProvincia");
            let url = $urlBase + "/provincias/" + idPais;
            el.empty();
            el.append("<option></option>");
            $.ajax({
                url: url,
                method: 'GET',
                success: function (response){
                    if(response.success){
                        $.each(response.data, function (i, e){
                            el.append(`<option value="${e.IdProvincia}">${e.Descrip}</option>`);
                        });
                    } 
                }
            });    
        });

        $("#idProvincia").on("change", function (e){
            let idProvincia = $(this).val();
            let el = $("#idPartido");
            let url = $urlBase + "/partidos/" + idProvincia;
            el.empty();
            el.append("<option></option>");
            $.ajax({
                url: url,
                method: 'GET',
                success: function (response){
                    if(response.success){
                        $.each(response.data, function (i, e){
                            el.append(`<option value="${e.IdPartido}">${e.Descrip}</option>`);
                        });
                    } 
                }
            });
        });

        $("#idPartido").on("change", function (e){
            let idPartido = $(this).val();
            let el = $("#idLocalidad");
            let url = $urlBase + "/localidades/" + idPartido;
            el.empty();
            el.append("<option></option>");
            $.ajax({
                url: url,
                method: 'GET',
                success: function (response){
                    if(response.success){
                        $.each(response.data, function (i, e){
                            el.append(`<option value="${e.IdLocalidad}">${e.Descrip}</option>`);
                        });
                    } 
                }
            });
        });

    }
    return {
        init: function () {
            initDataTable();
            llenaComboBox($urlBase + "/paises", $("#idPais"));
            llenaComboBox($urlBase + "/catfiscal/ARG", $("#idCatFiscal"));
            llenaComboBox($urlBase + "/administracion/empresa/tipopaginas/" + $("#Idi_idiomaPpal").val(), $("#cboTipoPagina"));
            reseteaSolapas();
        }
    }
}();