@php
    use Illuminate\Support\Facades\Lang;
@endphp
<!DOCTYPE html>
<html lang="es">
    <head>
        <meta charset="utf-8" />
        <title>Dashboard | ControlFlow</title>
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta content="ControlFlow" name="description" />
        <meta content="ControlFlow" name="author" />
        <meta http-equiv="X-UA-Compatible" content="IE=edge" />
        <link rel="shortcut icon" href="{{ asset('assets/images/favicon.ico') }}">
        <link href="{{ asset('assets/libs/flatpickr/flatpickr.min.css') }}" rel="stylesheet" type="text/css" />
        <link href="{{ asset('assets/libs/nestable2/jquery.nestable.min.css') }}" rel="stylesheet" />
        <link href="{{ asset('assets/libs/quill/quill.core.css') }}" rel="stylesheet" type="text/css" />
        <link href="{{ asset('assets/libs/quill/quill.bubble.css') }}" rel="stylesheet" type="text/css" />
        <link href="{{ asset('assets/libs/quill/quill.snow.css') }}" rel="stylesheet" type="text/css" />
        <link href="{{ asset('assets/libs/dropify/css/dropify.min.css') }}" rel="stylesheet" type="text/css" />
        <link href="{{ asset('assets/libs/sweetalert2/sweetalert2.min.css') }}" rel="stylesheet" type="text/css" />
        <link href="{{ asset('assets/libs/datatables.net-bs4/css/dataTables.bootstrap4.min.css') }}" rel="stylesheet" type="text/css" />
        <link href="{{ asset('assets/libs/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css') }}" rel="stylesheet" type="text/css" />
        <link href="{{ asset('assets/libs/datatables.net-select-bs4/css/select.bootstrap4.min.css') }}" rel="stylesheet" type="text/css" />
        <link href="{{ asset('assets/libs/flatpickr/flatpickr.min.css') }}" rel="stylesheet" type="text/css" />
        <link href="{{ asset('assets/libs/selectize/css/selectize.bootstrap3.css') }}" rel="stylesheet" type="text/css" />
        <link href="{{ asset('assets/css/bootstrap.min.css') }}" rel="stylesheet" type="text/css" id="bs-default-stylesheet" />
        <link href="{{ asset('assets/css/app.min.css') }}" rel="stylesheet" type="text/css" id="app-default-stylesheet" />
        <link href="{{ asset('assets/css/bootstrap-dark.min.css') }}" rel="stylesheet" type="text/css" id="bs-dark-stylesheet" />
        <link href="{{ asset('assets/css/app-dark.min.css') }}" rel="stylesheet" type="text/css" id="app-dark-stylesheet" />
        <link href="{{ asset('assets/css/icons.min.css') }}" rel="stylesheet" type="text/css" />
        <style type="text/css">
            .has-error > span.help-block{
                color:#cf0000 !important;
            }
            .logo-box{
                background-color:#fff !important;
            }
            .dataTables_filter{
                text-align:left !important;
            }
            .btn-white{
                border:0 !important;
            }
            .btn-warning{
                background-color:#ed7f06;
            }
            .btn-outline-generico{
                color:#444;
            }
            .btn-outline-generico:hover{
                background-color:#ccc;
                color:#444;
            }
            .error-message{
                display:none;
            }
            .texto-resaltado{
                border-radius:4px;
                padding:2px 4px;
                background-color:rgba(0,0,0,0.6);
                display:inline;
            }
            .bg-transparent{
                background-color:rgba(0,0,0,0.3) !important;
            }
            .dd-button{
                display:inline-block;
                position:absolute;
                right:10px;
            }
            .dd-button a.action-icon{
                font-size:17px;
            }
            .tab-content {
                padding: 0 0 0 0; 
            }
            .input-required,
            .input-required:focus{
                background-color:#ccece8 !important;
            }
            .nav-tabs .nav-item.show .nav-link, 
            .nav-tabs .nav-link.active{
                background-color:#ed7f06 !important;
                color:#fff;
            }
            #empresa-datatable tr{
                cursor:pointer;
            }
            table.dataTable tbody tr.selected {
                color:#444;
                background-color: #eee !important;
            }
            table.dataTable tbody > tr.selected td, 
            table.dataTable tbody > tr > .selected td { 
                border-color:#eee;
            }
            #lista-novedades .inbox-item {
                background-color:#fff;
                border-top-left-radius: 8px;
                border-bottom-left-radius: 8px;
                margin-bottom:4px;
                -webkit-box-shadow: 0px 0px 3px 0px rgba(0,0,0,0.45);
                -moz-box-shadow: 0px 0px 3px 0px rgba(0,0,0,0.45);
                box-shadow: 0px 0px 3px 0px rgba(0,0,0,0.45);
            }
            #lista-novedades .inbox-item:hover {
                background-color:#ed7f06 !important;
                cursor:pointer;
            }
            #lista-novedades .inbox-item:hover *{
                color:#fff !important;
            }
        </style>
        <script>
            let $urlBase = "{{ URL::to('/') }}";
        </script>
        @yield('styles')
    </head>
    <body class="loading" data-layout='{"mode": "light", "width": "fluid", "menuPosition": "fixed", "sidebar": { "color": "light", "size": "default", "showuser": false}, "topbar": {"color": "dark"}, "showRightSidebarOnPageLoad": true}'>
        <div id="wrapper">
            @include('layout.partials.navbar')
            <div class="left-side-menu">
                <div class="h-100" data-simplebar>
                    @include('layout.partials.sidebar')
                </div>
            </div>
            <div class="content-page">
                <div class="content">
                    @yield('content') 
                </div>
                @include('layout.partials.footer')
            </div>
        </div>
        <script src="{{ asset('assets/js/vendor.min.js') }}"></script>
        <script src="{{ asset('assets/libs/flatpickr/flatpickr.min.js') }}"></script>
        <script src="{{ asset('assets/libs/selectize/js/standalone/selectize.min.js') }}"></script>
        <script src="{{ asset('assets/libs/sweetalert2/sweetalert2.min.js') }}"></script>
        <script src="{{ asset('assets/libs/datatables.net/js/jquery.dataTables.min.js') }}"></script>
        <script src="{{ asset('assets/libs/datatables.net-bs4/js/dataTables.bootstrap4.min.js') }}"></script>
        <script src="{{ asset('assets/libs/datatables.net-responsive/js/dataTables.responsive.min.js') }}"></script>
        <script src="{{ asset('assets/libs/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js') }}"></script>
        <script src="{{ asset('assets/libs/jquery-datatables-checkboxes/js/dataTables.checkboxes.min.js') }}"></script>
        <script src="{{ asset('assets/js/app.min.js') }}"></script> 
        @yield('script')
    </body>
</html>