<!DOCTYPE html>
<html lang="es">
    <head>
        <meta charset="utf-8" />
        <title>ControlFlow | Inicio de Sesion</title>
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta content="ControlFlow" name="description" />
        <meta content="ControlFlow" name="author" />
        <meta http-equiv="X-UA-Compatible" content="IE=edge" />
        <link rel="shortcut icon" href="<?php echo e(asset('assets/images/favicon.ico')); ?>">
        <link href="<?php echo e(asset('assets/libs/ladda/ladda-themeless.min.css')); ?>" rel="stylesheet">
		<link href="<?php echo e(asset('assets/css/bootstrap.min.css')); ?>" rel="stylesheet" type="text/css" id="bs-default-stylesheet" />
		<link href="<?php echo e(asset('assets/css/app.min.css')); ?>" rel="stylesheet" type="text/css" id="app-default-stylesheet" />
		<link href="<?php echo e(asset('assets/css/bootstrap-dark.min.css')); ?>" rel="stylesheet" type="text/css" id="bs-dark-stylesheet" />
		<link href="<?php echo e(asset('assets/css/app-dark.min.css')); ?>" rel="stylesheet" type="text/css" id="app-dark-stylesheet" />
        <link href="<?php echo e(asset('assets/css/icons.min.css')); ?>" rel="stylesheet" type="text/css" />
        <script>
            let $urlBase = "<?php echo e(URL::to('/')); ?>";
        </script>
        <style type="text/css">
            .has-error > span.help-block{
                color:#cf0000 !important;
            }
            .auth-brand {
                /*top: 1rem !important;*/
            }
            .error-login{
                display:none;
            }
            .btn-success{
                color: #fff !important;
                background-color: #ed7f06 !important;
                border-color: #ed7f06 !important;
            }
            .custom-control-input:checked~.custom-control-label::before{
                color: #fff !important;
                border-color: #ed7f06 !important;
                background-color: #ed7f06 !important;
            }
        </style>
    </head>
    <body class="loading auth-fluid-pages pb-0">
        <div class="auth-fluid">
            <div class="auth-fluid-form-box">
                <div class="align-items-center d-flex h-100">
                    <div class="card-body">
                        <div class="auth-brand text-center text-lg-left">
                            <div class="auth-logo">
                                <a href="index.html" class="logo logo-dark text-center">
                                    <span class="logo-lg">
                                        <!--<img src="<?php echo e(asset('assets/images/logo.png')); ?>" alt="" height="60">-->
                                    </span>
                                </a>
            
                                <a href="index.html" class="logo logo-light text-center">
                                    <span class="logo-lg">
                                        <img src="<?php echo e(asset('assets/images/logo.png')); ?>" alt="" height="22">
                                    </span>
                                </a>
                            </div>
                        </div>
                        <h4 class="mt-3">Inicio de sesion</h4>
                        <!--<p class="text-muted mb-4">A continuacion ingrese su Email y Password.</p>-->
                        <form id="form-login">
                            <?php echo csrf_field(); ?>
                            <div class="form-group">
                                <label for="email">Email</label>
                                <input class="form-control" type="email" id="email" name="email" required="" placeholder="Ingrese su email" autocomplete="off" value="<?php echo e(request()->cookie('remember_email')); ?>">
                            </div>
                            <div class="form-group">
                                <a href="<?php echo e(url('/olvido')); ?>" class="text-muted float-right"><small>Olvido su password?</small></a>
                                <label for="password">Password</label>
                                <div class="input-group input-group-merge">
                                    <input type="password" id="password" name="password" class="form-control" placeholder="Ingrese su password" value="<?php echo e(request()->cookie('remember_password')); ?>">
                                    <div class="input-group-append" data-password="false">
                                        <div class="input-group-text">
                                            <span class="password-eye"></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="email">Idioma</label>
                                <select name="idioma" id="idioma" class="form-control">
                                    <option value="es" <?php if(request()->cookie('remember_idioma') == 'es'): ?> selected <?php endif; ?>>Español</option>
                                    <option value="en" <?php if(request()->cookie('remember_idioma') == 'en'): ?> selected <?php endif; ?>>English</option>
                                    <option value="ps" <?php if(request()->cookie('remember_idioma') == 'ps'): ?> selected <?php endif; ?>>Portugues</option>
                                </select>
                            </div>
                            <div class="form-group mb-3">
                                <div class="custom-control custom-checkbox">
                                    <input type="checkbox" class="custom-control-input" id="checkbox-signin" name="remember" value="1" <?php echo e(request()->hasCookie('remember_email') ? 'checked' : ''); ?>>
                                    <label class="custom-control-label" for="checkbox-signin">Recordar datos</label>
                                </div>
                            </div>
                            <div class="error-login">
                                <div class="alert alert-danger text-center">

                                </div>
                            </div>
                            <div class="form-group mb-0 text-center">
                                <button class="ladda-button btn btn-success btn-block" id="btn-ingresar" dir="ltr" data-style="slide-down" type="submit">
                                    <span class="ladda-label"><strong>Ingresar</strong></span>
                                    <span class="ladda-spinner"></span>
                                    <div class="ladda-progress" style="width: 0px;"></div>
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <script src="<?php echo e(asset('assets/js/vendor.min.js')); ?>"></script>
        <script src="<?php echo e(asset('assets/libs/ladda/spin.min.js')); ?>"></script>
        <script src="<?php echo e(asset('assets/libs/ladda/ladda.min.js')); ?>"></script>
        <script src="<?php echo e(asset('assets/js/pages/loading-btn.init.js')); ?>"></script>
        <script src="<?php echo e(asset('assets/js/app.min.js')); ?>"></script> 
        <script src="<?php echo e(asset('assets/js/app/auth/login.js')); ?>"></script>
    </body>
</html><?php /**PATH C:\xampp\htdocs\ControlFlow\resources\views/auth/index.blade.php ENDPATH**/ ?>