<?php

namespace App\Http\Controllers\Configuracion;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use DataTables;
use Validator;

class EmpresasController extends Controller {

    private $permitted_chars = '0123456789abcdefghijklmnopqrstuvwxyz';

    public function __construct()
    {
        $this->middleware(function ($request, $next) {
            if (!Auth::user()->hasPermissionTo('Empresas')) {
                return response()->view('errors.403', [
                    'modulo' => 'Empresas'
                ], 403);
            }

            return $next($request);
        });
    }

    public function index(){
        $paises = DB::table("tip_pais")->where("Hab", 1)->get();
        return view('configuracion.empresas.index')
            ->with('paises', $paises);
    }

    public function get(){
        $empresa = DB::table('con_empresa');
        $empresa = $empresa->where("Hab", 1);
        $empresa = $empresa->orderBy("idEmpresa", "ASC");
        $empresa = $empresa->get(); 
        return Datatables::of($empresa)
            ->addIndexColumn()
            ->addColumn('Accion', function($row){
                return "";
            })
            ->rawColumns(['action'])
            ->make(true);
    }

    public function edit($idEmpresa){
        $empresa = DB::table('con_empresa');
        $empresa = $empresa->where("idEmpresa", $idEmpresa);
        $empresa = $empresa->first();
        return response()->json([
            'success' => true,
            'data' => $empresa,
        ]);
    }

    public function store(Request $request){
        
        $rules = [
            'RazonSocial' => 'required',
            'idPais' => 'required',
            'idProvincia' => 'required',
            'idPartido' => 'required',
            'idLocalidad' => 'required',
            'Direccion' => 'required',
            'CodigoPostal' => 'required'
        ];

        $messages = [
            'required' => 'El campo :attribute es obligatorio.',
        ];

        $attributes = [
            'RazonSocial'   => 'razón social',
            'idPais'        => 'país',
            'idProvincia'   => 'provincia',
            'idPartido'     => 'partido',
            'idLocalidad'   => 'localidad',
            'Direccion'     => 'direccion',
            'CodigoPostal'  => 'código postal'
        ];

        $validator = Validator::make($request->all(), $rules, $messages);
        $validator->setAttributeNames($attributes);

        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'error' => $validator->errors()->all()
            ]);
        }
        
        if(!$request->idEmpresa){
            $insertId = DB::table('con_empresa')->insertGetId([
                'RazonSocial' => $request->RazonSocial,
                'NombreFantasia' => $request->NombreFantasia,
                'Email' => $request->Email,
                'Web' => $request->Web,
                'Telefonos' => $request->Telefonos,
                'Celular' => $request->Celular,
                'IdPais' => $request->idPais,
                'IdProvincia' => $request->idProvincia,
                'IdPartido' => $request->idPartido,
                'IdLocalidad' => $request->idLocalidad,
                'CodigoPostal' => $request->CodigoPostal,
                'Direccion' => $request->Direccion,
                'Hab' => $request->Hab,
                'FechaHoraAlta' => \Carbon\Carbon::now(),
                'UsrUltimaModificacion' => Auth::user()->usuario
            ]);
            if($insertId){
                $response = [
                    "success" => true,
                    "message" => "Registro #{$insertId} creado con exito"
                ];
            }
        }else{
            DB::table('con_empresa')->where("idEmpresa", $request->idEmpresa)->update([
                'RazonSocial' => $request->RazonSocial,
                'NombreFantasia' => $request->NombreFantasia,
                'Email' => $request->Email,
                'Web' => $request->Web,
                'Telefonos' => $request->Telefonos,
                'Celular' => $request->Celular,
                'IdPais' => $request->idPais,
                'IdProvincia' => $request->idProvincia,
                'IdPartido' => $request->idPartido,
                'IdLocalidad' => $request->idLocalidad,
                'CodigoPostal' => $request->CodigoPostal,
                'Direccion' => $request->Direccion,
                'Hab' => $request->Hab,
                'FechaUltimaModificacion' => \Carbon\Carbon::now(),
                'UsrUltimaModificacion' => Auth::user()->usuario
            ]);    
            
            $response = [
                "success" => true,
                "message" => "Registro #{$request->id} modificado con exito"
            ];
        }
        return response()->json($response);

    }

    public function destroy($idEmpresa){
        $Empresa = DB::table("con_empresa")->where("idEmpresa", $idEmpresa)->update([
            'Hab' => 0
        ]);    
        $response = [
            'success' => true,
            'message' => 'Empresa inhabilitada con exito'
        ];
        return response()->json($response);
    }
}
