<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

class UserFactory extends Factory
{
    protected $model = \App\Models\User::class;

    public function definition()
    {
        return [
            'idEmpresa'    => $this->faker->numerify('######'),
            'nombre'       => $this->faker->firstName,
            'apellido'     => $this->faker->lastName,
            'usuario'      => $this->faker->unique()->userName,
            'email'        => $this->faker->unique()->safeEmail,
            'departamento' => $this->faker->word,
            'telefonos'    => $this->faker->phoneNumber,
            'clave'        => bcrypt('123456'), 
            'remember_token' => Str::random(10),
        ];
    }
}
