<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('con_empresa', function (Blueprint $table) {
            $table->increments('idEmpresa')->comment('Vinculacion Empresa Base de Datos');
            $table->string('RazonSocial', 50)->default('')->comment('Razon social');
            $table->string('NombreFantasia', 100)->nullable()->comment('Nombre de Fantasia');
            $table->string('Telefonos', 40)->nullable()->comment('Telefonos');
            $table->string('Celular', 20)->nullable()->comment('Celulares');
            $table->string('Email', 90)->nullable()->comment('Direccion de email principal');
            $table->string('Web', 90)->nullable()->comment('Sitio web de la empresa');
            $table->string('IdPais', 3)->default('')->comment('id Pais');
            $table->string('Direccion', 50)->nullable()->comment('Direccion (Calle, Numero, Piso)');
            $table->integer('IdLocalidad')->default(0)->comment('idLocalidad');
            $table->integer('IdPartido')->default(0)->comment('id Partido');
            $table->string('CodigoPostal', 10)->nullable()->comment('Cod postal');
            $table->string('IdProvincia', 3)->default('')->comment('Provincias');
            $table->dateTime('FechaHoraAlta')->default(DB::raw("'0000-00-00 00:00:00'"))->comment('Alta de la empresa');
            $table->dateTime('FechaUltimaModificacion')->default(DB::raw("'0000-00-00 00:00:00'"))->comment('Ultima Modificacion');
            $table->string('UsrUltimaModificacion', 10)->nullable()->comment('Usuario que hizo la modificacion');
            $table->boolean('Hab')->default(0)->comment('Habilitado=1 Dehabilitado = 0');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('con_empresa');
    }
};
