<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class TipPaisSeeder extends Seeder
{
    public function run(): void
    {
        $paises = [
            ['idPais' => 'ARG', 'Descrip' => 'Argentina',     'Prefijo' => '+54',  'Hab' => 1],
            ['idPais' => 'BOL', 'Descrip' => 'Bolivia',       'Prefijo' => '+591', 'Hab' => 0],
            ['idPais' => 'BRA', 'Descrip' => 'Brasil',        'Prefijo' => '+55',  'Hab' => 1],
            ['idPais' => 'CHL', 'Descrip' => 'Chile',         'Prefijo' => '+56',  'Hab' => 1],
            ['idPais' => 'COL', 'Descrip' => 'Colombia',      'Prefijo' => '+57',  'Hab' => 0],
            ['idPais' => 'CRI', 'Descrip' => 'Costa Rica',    'Prefijo' => '+506', 'Hab' => 0],
            ['idPais' => 'ECU', 'Descrip' => 'Ecuador',       'Prefijo' => '+593', 'Hab' => 0],
            ['idPais' => 'GTM', 'Descrip' => 'Guatemala',     'Prefijo' => '+502', 'Hab' => 0],
            ['idPais' => 'HND', 'Descrip' => 'Honduras',      'Prefijo' => '+504', 'Hab' => 0],
            ['idPais' => 'MEX', 'Descrip' => 'Mexico',        'Prefijo' => '+52',  'Hab' => 0],
            ['idPais' => 'PRY', 'Descrip' => 'Paraguay',      'Prefijo' => '+595', 'Hab' => 1],
            ['idPais' => 'SLV', 'Descrip' => 'El Salvador',   'Prefijo' => '+503', 'Hab' => 0],
            ['idPais' => 'URY', 'Descrip' => 'Uruguay',       'Prefijo' => '+598', 'Hab' => 1],
        ];

        DB::table('tip_pais')->insert($paises);
    }
}
